//
//  SCFileSystem.h
//  SweetCocoaFoundation
//
//  Created by Rico on 6/18/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface SCFileSystem : NSObject

+ (BOOL) isHiddenItemAtPath:(NSString*)itemPath;

+ (BOOL) isDirectoryAtPath:(NSString*)path;

+ (BOOL) isFileAtPath:(NSString*)path;

+ (BOOL) isVolume:(NSString*)filePath;

+ (BOOL) isItemOnDesktopWithPath:(NSString*)itemPath;

+ (BOOL) isAliasAtPath:(NSString*)path;

+ (NSString*) localizedNameForItemAtPath:(NSString*)path;

+ (void) addDirectoriesOfType:(NSSearchPathDirectory)directoryType to:(NSMutableSet*)paths;

+ (BOOL) isItemAtPath:(NSString*)pathOne onSameVolumeAsItemAtPath:(NSString*)otherPath;

+ (NSString*) volumeForItemAtPath:(NSString*)thePath;

+ (NSString*) localizedVolumeNameForItemAtPath:(NSString*)path;

+ (NSURL*) desktopURL;
+ (NSString*)desktopPath;

+ (BOOL) isEmptyDirectoryAtPath:(NSString*)path;

+ (NSURL*) securityScopedURLWithPath:(NSString*)path error:(NSError **)error;

+ (NSData*) bookmarkDataWithSecurityScopeForPath:(NSString*)path error:(NSError**)error;

+ (NSData*) askForAccessToFolder:(NSString*)path title:(NSString*)title prompt:(NSString*)prompt;

+ (BOOL) isTrashedFileAtPath:(NSString*)path;

+ (NSString*)realHomeDirectory;

+ (NSString*)documentsFolder;

+ (NSString*)desktopFolderName;

+ (NSURL *)resolveAliasAtPath:(NSString *)path error:(NSError**)outError;

+ (BOOL)isApplicationAtPath:(NSString*)path error:(NSError**)outError;

+ (BOOL)makeAliasForItemAtPath:(NSString*)itemPath aliasPath:(NSString*)aliasPath error:(NSError**)outError;

@end
